const express = require('express');
const sequelize = require('./db');
const cors = require('cors');
const fileUpload = require('express-fileupload');
require("dotenv").config();

const app = express();
const port = 8000;

// Enable CORS
app.use(cors());

// Middleware to parse JSON body
app.use(express.json());

//file uplaod
app.use("/Assets", express.static(__dirname + "/Assets"));
app.use(fileUpload());

(async () => {
    try {
        await sequelize.authenticate();
        console.log(`\x1b[38;5;37mConnection has been established successfully.\x1b[0m`);
    } catch (error) {
        console.error('Unable to connect to the database:', error);
    }
})()

//user routes
const Tours = require('./routes/TourRoute');``
app.use('/Tours', Tours);


const Cars = require('./routes/CarsRoute');
app.use('/Cars', Cars);

const Contact = require('./routes/ContactRoute');
app.use('/Contact', Contact);

const Login = require('./routes/LoginRoute');
app.use('/login', Login);





app.listen(port, () => {
    console.log(`\x1b[38;5;37mServer running on http://localhost:${port}\x1b[0m`);
});
