// auth.js

const jwt = require('jsonwebtoken');
const asyncHandler = require('express-async-handler');
const { getUserById } = require('../controllers/UserController');

const protect = asyncHandler(async (req, res, next) => {
    let token;
    if (req.headers.authorization && req.headers.authorization.startsWith('Bearer')) {
        try {
            token = req.headers.authorization.split(' ')[1];

            const decoded = jwt.verify(token, process.env.JWT_SECRET);

            const user = await getUserById(decoded.id);

            if (!user) {
                return res.status(404).json({ status: 'error', message: 'User not found' });
            }

            req.user = user; 

            next(); 

        } catch (err) {
            //console.log(err);
            res.status(401).send({ status: 'error', message: 'Not authorized' });
        }
    } else {
        res.status(401).send({ status: 'error', message: 'Not authorized, no token' });
    }
});

module.exports = { protect };
