const { json } = require("sequelize");
const sequelize = require("../db");

const formatDate = (date) => {
    const year = date.getFullYear();
    const month = String(date.getMonth() + 1).padStart(2, '0');
    const day = String(date.getDate()).padStart(2, '0');
    const hours = String(date.getHours()).padStart(2, '0');
    const minutes = String(date.getMinutes()).padStart(2, '0');
    const seconds = String(date.getSeconds()).padStart(2, '0');
    return `${year}-${month}-${day} ${hours}:${minutes}:${seconds}`;
};

//create item
const CreateItem = async (req, res) => {
    try {
        if (req.body.previewImg == 'null') {
            // No image provided
            const [results, metadata] = await sequelize.query(`
                INSERT INTO Item (ItemName, ItemCategoryID, costPrice, sellingPrice, isfavourite, ItemRemark, ItemImage, IsActive)
                VALUES(:itemName, :itemCategoryID, :costPrice, :sellingPrice, :isfavourite, :itemRemark, :itemImage, :IsActive)
            `, {
                replacements: {
                    itemName: req.body.itemName,
                    itemCategoryID: parseInt(req.body.itemCategoryID),
                    costPrice: parseFloat(req.body.costPrice),
                    sellingPrice: parseFloat(req.body.sellingPrice),
                    isfavourite: parseInt(req.body.isFavourite),
                    itemRemark: req.body.itemRemark,
                    itemImage: "1000000000000.jpg",
                    IsActive: parseInt(req.body.status)
                }
            });
            res.json(results);
        } else {
            // Image provided
            const image = req.files.file;
            const itemImageName = new Date().getTime();
            await image.mv("Assets/Items/" + `${itemImageName}.jpg`);

            const [results, metadata] = await sequelize.query(`
                INSERT INTO Item (ItemName, ItemCategoryID, costPrice, sellingPrice, isfavourite, ItemRemark, ItemImage, IsActive)
                VALUES(:itemName, :itemCategoryID, :costPrice, :sellingPrice, :isfavourite, :itemRemark, :itemImage, :IsActive)
            `, {
                replacements: {
                    itemName: req.body.itemName,
                    itemCategoryID: parseInt(req.body.itemCategoryID),
                    costPrice: parseFloat(req.body.costPrice),
                    sellingPrice: parseFloat(req.body.sellingPrice),
                    isfavourite: parseInt(req.body.isFavourite),
                    itemRemark: req.body.itemRemark,
                    itemImage: `${itemImageName}.jpg`,
                    IsActive: parseInt(req.body.status)
                }
            });
            res.json(results);
        }
    } catch (error) {
        return res.status(400).json({ error: error.message });
    }
};

//Get all item details
const GetAllItemDetails = async (req, res) => {
    try {
        const [results, metadata] = await sequelize.query('SELECT I.*,C.CategoryName FROM Item I INNER JOIN Category C ON C.CategoryID = I.ItemCategoryID order by I.ItemName');
        res.json(results);
    } catch (error) {
        return res.status(500).json({ err: error.message })
    }
}

// Get all item details for billing
const GetAllItemDetailsforBilling = async (req, res) => {
    try {
        const [results, metadata] = await sequelize.query(`
            SELECT i.ItemID,
                   i.ItemName, 
                   i.ItemCategoryID,
                   i.sellingPrice,
                   i.costPrice,
                   i.ItemImage, 
                   i.isfavourite, 
                   i.qty, 
                   COALESCE(s.stockId, -1) AS stockId
            FROM Item i
            LEFT JOIN (SELECT * FROM Shop1_Stock GROUP BY itemName) s 
            ON i.ItemID = s.ItemID 
            WHERE i.IsActive = 1 
            GROUP BY i.ItemID, 
                     i.ItemName, 
                     i.ItemCategoryID, 
                     i.sellingPrice,
                     i.ItemImage, 
                     i.isfavourite, 
                     i.qty, 
                     s.stockId;
        `);
        res.json(results);
    } catch (error) {
        return res.status(500).json({ err: error.message });
    }
};

// Get item details by ItemID
const GetItemDetailByItemID = async (req, res) => {
    try {
        const UpdateID = req.params.updateID;
        const [results, metadata] = await sequelize.query(`
            SELECT ItemName, 
                   ItemCategoryID, 
                   sellingPrice, 
                   isfavourite, 
                   ItemRemark, 
                   ItemImage, 
                   IsActive,
                   costPrice
            FROM Item
            WHERE ItemID = ${UpdateID}
        `);
        res.json(results);
    } catch (error) {
        res.status(500).send("Server Error");
    }
};

// Update item details
const UpdateItemDetail = async (req, res) => {
    try {
        if (req.body.previewImg == 'null') {
            // Update without image
            const [results, metadata] = await sequelize.query(`
                UPDATE Item
                SET ItemName = :itemName,
                    ItemCategoryID = :itemCategoryID,
                    sellingPrice = :sellingPrice,
                    isfavourite = :isfavourite,
                    ItemRemark = :itemRemark,
                    ItemImage = :itemImage,
                    IsActive = :IsActive
                WHERE ItemID = :itemID
            `, {
                replacements: {
                    itemID: parseInt(req.body.updateID),
                    itemName: req.body.itemName,
                    itemCategoryID: parseInt(req.body.itemCategoryID),
                    sellingPrice: parseFloat(req.body.sellingPrice),
                    isfavourite: parseInt(req.body.isFavourite),
                    itemRemark: req.body.itemRemark,
                    itemImage: null,
                    IsActive: parseInt(req.body.status)
                }
            });
            res.json(results);
        } else if (req.body.previewImg !== 'null' && req.body.file === 'null') {
            // Update keeping the existing image
            const [results, metadata] = await sequelize.query(`
                UPDATE Item
                SET ItemName = :itemName,
                    ItemCategoryID = :itemCategoryID,
                    sellingPrice = :sellingPrice,
                    isfavourite = :isfavourite,
                    ItemRemark = :itemRemark,
                    ItemImage = :itemImage,
                    IsActive = :IsActive
                WHERE ItemID = :itemID
            `, {
                replacements: {
                    itemID: parseInt(req.body.updateID),
                    itemName: req.body.itemName,
                    itemCategoryID: parseInt(req.body.itemCategoryID),
                    sellingPrice: parseFloat(req.body.sellingPrice),
                    isfavourite: parseInt(req.body.isFavourite),
                    itemRemark: req.body.itemRemark,
                    itemImage: req.body.previewImg,
                    IsActive: parseInt(req.body.status)
                }
            });
            res.json(results);
        } else {
            // Update with a new image
            const image = req.files.file;
            const itemImageName = new Date().getTime();
            await image.mv("Assets/Items/" + `${itemImageName}.jpg`);

            const [results, metadata] = await sequelize.query(`
                UPDATE Item
                SET ItemName = :itemName,
                    ItemCategoryID = :itemCategoryID,
                    sellingPrice = :sellingPrice,
                    isfavourite = :isfavourite,
                    ItemRemark = :itemRemark,
                    ItemImage = :itemImage,
                    IsActive = :IsActive
                WHERE ItemID = :itemID
            `, {
                replacements: {
                    itemID: parseInt(req.body.updateID),
                    itemName: req.body.itemName,
                    itemCategoryID: parseInt(req.body.itemCategoryID),
                    sellingPrice: parseFloat(req.body.sellingPrice),
                    isfavourite: parseInt(req.body.isFavourite),
                    itemRemark: req.body.itemRemark,
                    itemImage: `${itemImageName}.jpg`,
                    IsActive: parseInt(req.body.status)
                }
            });
            res.json(results);
        }
    } catch (error) {
        return res.status(400).json({ error: error.message });
    }
};


// add items to the favourites from the billing dashboard
const ItemsAddToFavourites = async (req, res) => {
    try {
        const [results, metadata] = await sequelize.query(`
            UPDATE Item
            SET isfavourite = :isfavourite
            WHERE ItemID = :itemID
        `, {
            replacements: {
                itemID: parseInt(req.body.id),
                isfavourite: parseInt(req.body.fav)
            }
        });
        res.json(results);
    } catch (error) {
        return res.status(400).json({ error: error.message })
    }
}

// get all active item details for the report
const GetAllActiveItemDetails = async (req, res) => {
    try {
        const [results, metadata] = await sequelize.query('SELECT I.ItemID, I.ItemName, I.ItemCategoryID, C.CategoryName, I.sellingPrice, I.ItemTypeID FROM Item I INNER join Category C on C.CategoryID = I.ItemCategoryID WHERE I.IsActive = 1');
        res.json(results);
    } catch (error) {
        return res.status(500).json({ err: error.message })
    }



    
}


const getitemUnitprice = async (req, res) => {


    try {
        const [results, metadata] = await sequelize.query(`
           SELECT  I.sellingPrice FROM Item I INNER join Category C on C.CategoryID = I.ItemCategoryID 
           WHERE I.IsActive = 1 and I.ItemID = :itemID
        `, {
            replacements: {
                itemID: parseInt(req.body.itemid),
                isfavourite: parseInt(req.body.fav)
            }
        });
        res.json(results);
    } catch (error) {
        return res.status(400).json({ error: error.message })
    }
}

// get all item stock details
const GetAllActiveStockdetails = async (req, res) => {
    const branchID = req.params.branchID;
    try {
        if (branchID == 1) {
            const [results, metadata] = await sequelize.query('SELECT  S1.itemId, S1.itemName, C.CategoryName, C.CategoryID, S1.stockExpireDate FROM Shop1_Stock S1 INNER JOIN Category C ON C.CategoryID = S1.itemCategoryId GROUP BY S1.itemId');
            // const [results, metadata] = await sequelize.query('SELECT DISTINCT S1.stockId, S1.itemId, S1.itemName, C.CategoryName, C.CategoryID, S1.stockExpireDate FROM Shop1_Stock S1 INNER JOIN Category C ON C.CategoryID = S1.itemCategoryId');
            res.json(results);
        } else if (branchID == 2) {
            const [results, metadata] = await sequelize.query('SELECT  S1.itemId, S1.itemName, C.CategoryName, C.CategoryID, S1.stockExpireDate FROM Shop2_Stock S1 INNER JOIN Category C ON C.CategoryID = S1.itemCategoryId GROUP BY S1.itemId');
            res.json(results);
        } else if (branchID == 3) {
            const [results, metadata] = await sequelize.query('SELECT  S1.itemId, S1.itemName, C.CategoryName, C.CategoryID, S1.stockExpireDate FROM Shop3_Stock S1 INNER JOIN Category C ON C.CategoryID = S1.itemCategoryId GROUP BY S1.itemId');
            res.json(results);
        } else {
            const [results, metadata] = await sequelize.query('SELECT  S1.itemId, S1.itemName, C.CategoryName, C.CategoryID, S1.stockExpireDate FROM Shop3_Stock S1 INNER JOIN Category C ON C.CategoryID = S1.itemCategoryId GROUP BY S1.itemId');
            res.json(results);
        }
    } catch (error) {
        return res.status(500).json({ err: error.message })
    }
}

// serach stock details
const GetSearchStockDetails = async (req, res) => {
    //console.log("req.body::> ", req.body)
    try {
        if (req.body.branchID == 1) {
            if (req.body.itemID == 0) {
                const [results, metadata] = await sequelize.query(`
                    SELECT 
                        S1.stockId, 
                        S1.itemId, 
                        S1.itemName, 
                        C.CategoryName, 
                        S1.stockInDate, 
                        S1.lastStockOutDate, 
                        S1.stockExpireDate, 
                        S1.stock 
                    FROM Shop1_Stock S1
                    INNER JOIN Category C ON C.CategoryID = S1.itemCategoryId 
                    WHERE S1.stockExpireDate BETWEEN :fromDate AND :toDate;
                `, {
                    replacements: {
                        fromDate: req.body.fromDate,
                        toDate: req.body.toDate,
                    }
                });
                res.json(results);
            } else {
                const [results, metadata] = await sequelize.query(`
                    SELECT 
                        S1.stockId, 
                        S1.itemId, 
                        S1.itemName, 
                        C.CategoryName, 
                        S1.stockInDate, 
                        S1.lastStockOutDate, 
                        S1.stockExpireDate, 
                        S1.stock 
                    FROM Shop1_Stock S1
                    INNER JOIN Category C ON C.CategoryID = S1.itemCategoryId 
                    WHERE 
                        (S1.itemId IS NULL OR S1.itemId = :itemID)
                        AND S1.stockExpireDate BETWEEN :fromDate AND :toDate;
    
                `, {
                    replacements: {
                        itemID: parseInt(req.body.itemID),
                        fromDate: req.body.fromDate,
                        toDate: req.body.toDate,
                    }
                });
                res.json(results);
            }

        } else if (req.body.branchID == 2) {
            if (req.body.itemID == 0) {
                const [results, metadata] = await sequelize.query(`
                    SELECT 
                        S1.stockId, 
                        S1.itemId, 
                        S1.itemName, 
                        C.CategoryName, 
                        S1.stockInDate, 
                        S1.lastStockOutDate, 
                        S1.stockExpireDate, 
                        S1.stock 
                    FROM Shop2_Stock S1
                    INNER JOIN Category C ON C.CategoryID = S1.itemCategoryId 
                    WHERE S1.stockExpireDate BETWEEN :fromDate AND :toDate;
                `, {
                    replacements: {
                        fromDate: req.body.fromDate,
                        toDate: req.body.toDate,
                    }
                });
                res.json(results);
            } else {
                const [results, metadata] = await sequelize.query(`
                    SELECT 
                        S1.stockId, 
                        S1.itemId, 
                        S1.itemName, 
                        C.CategoryName, 
                        S1.stockInDate, 
                        S1.lastStockOutDate, 
                        S1.stockExpireDate, 
                        S1.stock 
                    FROM Shop2_Stock S1
                    INNER JOIN Category C ON C.CategoryID = S1.itemCategoryId 
                    WHERE 
                        (S1.itemId IS NULL OR S1.itemId = :itemID)
                        AND S1.stockExpireDate BETWEEN :fromDate AND :toDate;
    
                `, {
                    replacements: {
                        itemID: parseInt(req.body.itemID),
                        fromDate: req.body.fromDate,
                        toDate: req.body.toDate,
                    }
                });
                res.json(results);
            }
        } else if (req.body.branchID == 3) {
            if (req.body.itemID == 0) {
                const [results, metadata] = await sequelize.query(`
                    SELECT 
                        S1.stockId, 
                        S1.itemId, 
                        S1.itemName, 
                        C.CategoryName, 
                        S1.stockInDate, 
                        S1.lastStockOutDate, 
                        S1.stockExpireDate, 
                        S1.stock 
                    FROM Shop3_Stock S1
                    INNER JOIN Category C ON C.CategoryID = S1.itemCategoryId 
                    WHERE S1.stockExpireDate BETWEEN :fromDate AND :toDate;
                `, {
                    replacements: {
                        fromDate: req.body.fromDate,
                        toDate: req.body.toDate,
                    }
                });
                res.json(results);
            } else {
                const [results, metadata] = await sequelize.query(`
                    SELECT 
                        S1.stockId, 
                        S1.itemId, 
                        S1.itemName, 
                        C.CategoryName, 
                        S1.stockInDate, 
                        S1.lastStockOutDate, 
                        S1.stockExpireDate, 
                        S1.stock 
                    FROM Shop3_Stock S1
                    INNER JOIN Category C ON C.CategoryID = S1.itemCategoryId 
                    WHERE 
                        (S1.itemId IS NULL OR S1.itemId = :itemID)
                        AND S1.stockExpireDate BETWEEN :fromDate AND :toDate;
    
                `, {
                    replacements: {
                        itemID: parseInt(req.body.itemID),
                        fromDate: req.body.fromDate,
                        toDate: req.body.toDate,
                    }
                });
                res.json(results);
            }
        } else if (req.body.branchID == 4) {
            if (req.body.itemID == 0) {
                const [results, metadata] = await sequelize.query(`
                    SELECT 
                        S1.stockId, 
                        S1.itemId, 
                        S1.itemName, 
                        C.CategoryName, 
                        S1.stockInDate, 
                        S1.lastStockOutDate, 
                        S1.stockExpireDate, 
                        S1.stock 
                    FROM Shop4_Stock S1
                    INNER JOIN Category C ON C.CategoryID = S1.itemCategoryId 
                    WHERE S1.stockExpireDate BETWEEN :fromDate AND :toDate;
                `, {
                    replacements: {
                        fromDate: req.body.fromDate,
                        toDate: req.body.toDate,
                    }
                });
                res.json(results);
            } else {
                const [results, metadata] = await sequelize.query(`
                    SELECT 
                        S1.stockId, 
                        S1.itemId, 
                        S1.itemName, 
                        C.CategoryName, 
                        S1.stockInDate, 
                        S1.lastStockOutDate, 
                        S1.stockExpireDate, 
                        S1.stock 
                    FROM Shop4_Stock S1
                    INNER JOIN Category C ON C.CategoryID = S1.itemCategoryId 
                    WHERE 
                        (S1.itemId IS NULL OR S1.itemId = :itemID)
                        AND S1.stockExpireDate BETWEEN :fromDate AND :toDate;
    
                `, {
                    replacements: {
                        itemID: parseInt(req.body.itemID),
                        fromDate: req.body.fromDate,
                        toDate: req.body.toDate,
                    }
                });
                res.json(results);
            }
        } else {
            //console.log("all branch")
            const [results, metadata] = await sequelize.query(`
                SELECT
                    S1.stockId,
                        S1.itemId,
                        S1.itemName,
                        C.CategoryName,
                        S1.stockInDate,
                        S1.lastStockOutDate,
                        S1.stockExpireDate,
                        S1.stock 
                            FROM Shop1_Stock S1
                            INNER JOIN Category C ON C.CategoryID = S1.itemCategoryId 
                            WHERE S1.stockExpireDate BETWEEN :fromDate AND :toDate
                    UNION
                    SELECT
                    S1.stockId,
                        S1.itemId,
                        S1.itemName,
                        C.CategoryName,
                        S1.stockInDate,
                        S1.lastStockOutDate,
                        S1.stockExpireDate,
                        S1.stock 
                            FROM Shop2_Stock S1
                            INNER JOIN Category C ON C.CategoryID = S1.itemCategoryId 
                            WHERE S1.stockExpireDate BETWEEN :fromDate AND :toDate
                    UNION
                    SELECT
                    S1.stockId,
                        S1.itemId,
                        S1.itemName,
                        C.CategoryName,
                        S1.stockInDate,
                        S1.lastStockOutDate,
                        S1.stockExpireDate,
                        S1.stock 
                            FROM Shop3_Stock S1
                            INNER JOIN Category C ON C.CategoryID = S1.itemCategoryId 
                            WHERE S1.stockExpireDate BETWEEN :fromDate AND :toDate
                    UNION
                    SELECT
                    S1.stockId,
                        S1.itemId,
                        S1.itemName,
                        C.CategoryName,
                        S1.stockInDate,
                        S1.lastStockOutDate,
                        S1.stockExpireDate,
                        S1.stock 
                            FROM Shop4_Stock S1
                            INNER JOIN Category C ON C.CategoryID = S1.itemCategoryId 
                            WHERE S1.stockExpireDate BETWEEN :fromDate AND :toDate;
                `, {
                replacements: {
                    fromDate: req.body.fromDate,
                    toDate: req.body.toDate,
                }
            });
            res.json(results);
        }
    } catch (error) {
        return res.status(500).json({ err: error.message })
    }
}
// SELECT S1.stockId, S1.itemId, S1.itemName, C.CategoryName, S1.stockInDate, S1.lastStockOutDate, S1.stockExpireDate, S1.stock FROM Shop2_Stock S1 INNER JOIN Category C ON C.CategoryID = S1.itemCategoryId WHERE S1.itemId IS NULL OR S1.itemId = 24 AND S1.stockExpireDate BETWEEN '2024-11-22' AND '2028-11-22';

module.exports = {
    CreateItem,
    GetAllItemDetails,
    GetItemDetailByItemID,
    UpdateItemDetail,
    ItemsAddToFavourites,
    GetAllItemDetailsforBilling,
    GetAllActiveItemDetails,
    GetAllActiveStockdetails,
    GetSearchStockDetails,
    getitemUnitprice
}
