const sequelize = require('../db');

const formatDate = (date) => {
    const year = date.getFullYear();
    const month = String(date.getMonth() + 1).padStart(2, '0');
    const day = String(date.getDate()).padStart(2, '0');
    const hours = String(date.getHours()).padStart(2, '0');
    const minutes = String(date.getMinutes()).padStart(2, '0');
    const seconds = String(date.getSeconds()).padStart(2, '0');
    return `${year}-${month}-${day} ${hours}:${minutes}:${seconds}`;
};

//create doctor details
const CreateDoctor = async (req, res) => {
    try {
        const [results, metadata] = await sequelize.query(`
            INSERT INTO Doctors (Name,Phone,Role,IsActive)
            VALUES(:doctorName, :doctorPhone, :doctorRole, :status)
            `, {
            replacements: {
                doctorName: req.body.doctorName,
                doctorPhone: req.body.doctorPhone,
                doctorRole: parseInt(req.body.doctorRole),
                status: parseInt(req.body.status)
            }
        });
        res.json(results);
    } catch (error) {
        return res.status(500).json({ error: 'An error occurred' });
    }
}

//get all doctor details
const GetAllDoctorDetails = async (req, res) => {
    try {
        const [results, metadata] = await sequelize.query('SELECT DoctorID ,Name ,Phone ,Role ,IsActive FROM Doctors order by Name');
        res.json(results);
    } catch (error) {
        return res.status(500).json({ err: error.message })
    }
}

//get doctor details by ID
const GetDoctorDetailsByID = async (req, res) => {
    try {
        const updateID = req.params.updateID;
        const [results, metadata] = await sequelize.query(`
            SELECT DoctorID , Name ,Phone ,Role ,IsActive FROM Doctors WHERE DoctorID = ${updateID}
            `);
        res.json(results);
    } catch (error) {
        res.status(500).send("Server Error");
    }
}

//update doctor details
const UpdateDoctorDetails = async (req, res) => {
    try {
        const [results, metadata] = await sequelize.query(`
            UPDATE Doctors
            SET Name = :doctorName,
                Phone = :doctorPhone,
                Role = :doctorRole,
                IsActive = :status
            WHERE DoctorID = :doctorID
        `, {
            replacements: {
                doctorName: req.body.doctorName,
                doctorPhone: req.body.doctorPhone,
                doctorRole: parseInt(req.body.doctorRole),
                status: parseInt(req.body.status),
                doctorID: parseInt(req.body.doctorID)
            }
        });
        res.json(results);
    } catch (error) {
        return res.status(500).json({ error: 'An error occurred' });
    }
}

//get all active doctor details
const GetActiveDoctorDetails = async (req, res) => {
    try {
        const [results, metadata] = await sequelize.query('SELECT * FROM Doctors WHERE IsActive = 1 order by Name');
        res.json(results);
    } catch (error) {
        return res.status(500).json({ err: error.message })
    }
}

module.exports = {
    CreateDoctor,
    GetAllDoctorDetails,
    GetDoctorDetailsByID,
    UpdateDoctorDetails,
    GetActiveDoctorDetails
}