const sequelize = require("../db");
require("dotenv").config();
const nodemailer = require('nodemailer');

const transporter = nodemailer.createTransport({
    host: process.env.SMTP_HOST,
    port: process.env.SMTP_PORT,
    secure: true, // Must be true for port 465`
    auth: {
        user: process.env.SMTP_USER,
        pass: process.env.SMTP_PASS,
    },
});




const sendMails = async (req, res) => {
    console.log('sending email');
    try {
        const { name, email, message } = req.body;

        console.log("Received data:", { name, email, message });

        const mailOptions = {
            from: process.env.SMTP_USER, // Your email address
            to: 'kanishkaprabasara@gmail.com', // Destination email
            subject: 'New User Inquiry',
            html: `
                <html>
                    <body style="font-family: Arial, sans-serif; color: #333;">
                        <div style="max-width: 600px; margin: 0 auto; padding: 20px; background-color: #f9f9f9; border-radius: 8px; border: 1px solid #ddd;">
                            <h2 style="color: #2c3e50; text-align: center;">New User Inquiry</h2>
                            <p style="font-size: 16px; line-height: 1.6;">
                                <strong>Name:</strong> ${name} <br/>
                                <strong>Email:</strong> ${email} <br/>
                                <strong>Message:</strong> <br/>
                                <em style="color: #555;">${message}</em>
                            </p>
                            <hr style="border: 1px solid #ccc;" />
                            <p style="font-size: 14px; text-align: center; color: #777;">
                                This email was generated automatically. Please do not reply to this address.
                            </p>
                        </div>
                    </body>
                </html>
            `,
        };

        await transporter.sendMail(mailOptions);
        console.log('Email sent successfully');
        res.status(200).json({ success: true, message: 'Email sent successfully' });
    } catch (error) {
        console.error('Error sending email:', error);
        res.status(500).json({ success: false, error: error.message });
    }
}


const sendContact = async (req,res) => {
     try {
        const { name, email, message } = req.body;

        console.log("Received data:", { name, email, message });

        const mailOptions = {
            from: process.env.SMTP_USER, // Your email address
            to: 'kanishkaprabasara@gmail.com', // Destination email
            subject: 'New User Inquiry',
            html: `
                <html>
                    <body style="font-family: Arial, sans-serif; color: #333;">
                        <div style="max-width: 600px; margin: 0 auto; padding: 20px; background-color: #f9f9f9; border-radius: 8px; border: 1px solid #ddd;">
                            <h2 style="color: #2c3e50; text-align: center;">New User Inquiry</h2>
                            <p style="font-size: 16px; line-height: 1.6;">
                                <strong>Name:</strong> ${name} <br/>
                                <strong>Email:</strong> ${email} <br/>
                                <strong>Message:</strong> <br/>
                                <em style="color: #555;">${message}</em>
                            </p>
                            <hr style="border: 1px solid #ccc;" />
                            <p style="font-size: 14px; text-align: center; color: #777;">
                                This email was generated automatically. Please do not reply to this address.
                            </p>
                        </div>
                    </body>
                </html>
            `,
        };

        await transporter.sendMail(mailOptions);
        console.log('Email sent successfully');
        res.status(200).json({ success: true, message: 'Email sent successfully' });
    } catch (error) {
        console.error('Error sending email:', error);
        res.status(500).json({ success: false, error: error.message });
    }

}
const carRent = async (req, res) => {
    console.log('sending email');
    try {
        const { name, email, message} = req.body;

        console.log("Received data:", { name, email, message });

        const mailOptions = {
            from: process.env.SMTP_USER, // Your email address
            to: 'kanishkaprabasara@gmail.com', // Destination email
            subject: 'Car Rental Inquiry',
            html: `
                <html>
                    <body style="font-family: Arial, sans-serif; color: #333;">
                        <div style="max-width: 600px; margin: 0 auto; padding: 20px; background-color: #f4f4f4; border-radius: 8px;">
                            <h2 style="color: #2c3e50; text-align: center;">Car Rental Inquiry</h2>
                            <p style="font-size: 16px; line-height: 1.6;">
                                <strong>Name:</strong> ${name} <br/>
                                <strong>Email:</strong> ${email} <br/>
                                <strong>Message:</strong> <br/>
                                <em>${message}</em>
                            </p>
                            <hr style="border: 1px solid #ccc;" />
                            <p style="font-size: 14px; text-align: center; color: #777;">
                                This email was generated automatically. Please do not reply to this address.
                            </p>
                        </div>
                    </body>
                </html>
            `,
        };

        await transporter.sendMail(mailOptions);
        console.log('Email sent successfully');
        res.status(200).json({ success: true, message: 'Email sent successfully' });
    } catch (error) {
        console.error('Error sending email:', error);
        res.status(500).json({ success: false, error: error.message });
    }
}




module.exports = {
    sendMails,
    carRent,
    sendContact
    
}