const { json } = require("sequelize");
const sequelize = require("../db");
const path = require('path');
const fs = require('fs');



const CreateCar = async (req, res) => {
  const t = await sequelize.transaction(); // Start a transaction

  try {
    const { carCategory, passengerCount, remark, rate } = req.body;
    
    // Save the image if it's provided
    let savedFileName = null;

    if (req.files && req.files.carImage) {
      const carImage = req.files.carImage; // Assuming the key for the image is 'carImage'
      savedFileName = `car_${Date.now()}.jpg`;
      const uploadDir = path.join(__dirname, '..', 'Assets', 'Cars');

      // Create upload folder if it doesn't exist
      if (!fs.existsSync(uploadDir)) {
        fs.mkdirSync(uploadDir, { recursive: true });
      }

      // Save the uploaded image
      const fullPath = path.join(uploadDir, savedFileName);
      await carImage.mv(fullPath); // Move the file to the target folder
    }

    // Insert RentCars inside the transaction
    const [carResult, carMeta] = await sequelize.query(`
      INSERT INTO RentCars (CarCategory, PassengetCount, Remark, rate, image)
      VALUES (:carCategory, :passengerCount, :remark, :rate, :image)
    `, {
      replacements: {
        carCategory,
        passengerCount,
        remark,
        rate,
        image: savedFileName ? `${savedFileName}` : null // Save image path or null if no image
      },
      transaction: t
    });

    await t.commit(); // Commit the transaction if everything is successful

    return res.status(200).json({
      message: 'Car rental created successfully.',
      carId: carResult.insertId,
      carDetails: {
        carCategory,
        passengerCount,
        remark,
        rate,
        image: savedFileName ? `${savedFileName}` : null
      }
    });
  } catch (error) {
    await t.rollback(); // Rollback if any error occurs
    console.error('CreateCar error:', error);
    return res.status(500).json({ error: error.message });
  }
};



const GetAllCarDetails = async (req, res) => {
  try {
    const [result, metadata] = await sequelize.query(`
      SELECT carid, CarCategory, PassengetCount, Remark, rate, image
    FROM RentCars;
    `);

     return res.status(200).json({
      data: result
    });
    
  } catch (error) {
      console.error('Error fetching car details:', error);
      return res.status(500).json({ error: error.message });
  }
}

const GetAllCarDetailsById = async (req, res) => {

  const { carId } = req.body;
  if (!carId) {
    return res.status(400).json({ error: 'Tour ID is required' });
  }
  try {

        const [detailResult, detailMeta] = await sequelize.query(`

      SELECT carid, CarCategory, PassengetCount, Remark, rate, image
    FROM RentCars

      where carid = :carId;
      `, {
        replacements: {
          carId,
          
        }
      });
     return res.status(200).json({
      data: detailResult
    });
    
  } catch (error) {
      console.error('Error fetching car details:', error);
      return res.status(500).json({ error: error.message });
  }
}



const deleteCar = async (req, res) => {
  const { carId } = req.body; // Assuming you are passing the tourId in the request body

  try {
    // Start a transaction to ensure both delete operations are executed atomically
    const result = await sequelize.transaction(async (t) => {
      // First, delete from TourDetails where TourId matches
      const detailsDeleted = await sequelize.query(
        `DELETE FROM RentCars WHERE carId = :carId`,
        {
          replacements: { carId }, // Bind the tourId parameter
          type: sequelize.QueryTypes.DELETE,
          transaction: t,
        }
      );

    

      return { detailsDeleted };
    });

    // Return success response if both deletions were successful
    return res.status(200).json({
      message: "Car deleted successfully",
    });
    
  } catch (error) {
    console.error('Error deleting tour:', error);
    return res.status(500).json({ error: error.message });
  }
};








module.exports = {
    CreateCar,
    deleteCar,
    GetAllCarDetailsById,
    GetAllCarDetails

}
