const { json } = require("sequelize");
const sequelize = require("../db");

// Create invoice for Shop1
const CreateShop1Invoice = async (req, res) => {

  console.log(req.body)

    const {
      inv_no,
      username,
      inv_date,
      gross_total,
      discount,
      net_total,
      shop,
      paymentMethod,
      petid,
      items, // List of invoice detail items
    } = req.body;

    console.log(req.body)
  
    const transaction = await sequelize.transaction();
    try {
      // Insert into Shop1_Invoice_Header
      await sequelize.query(
        `
        INSERT INTO Shop1_Invoice_Header (
          inv_no,
          username,
          inv_date,
          gross_total,
          discount,
          net_total,
          shop,
          paymentMethod
        ) VALUES (
          :inv_no,
          :username,
          :inv_date,
          :gross_total,
          :discount,
          :net_total,
          :shop,
          :paymentMethod
        )
      `,
        {
          replacements: {
            inv_no,
            username,
            inv_date,
            gross_total: parseFloat(gross_total),
            discount: parseFloat(discount),
            net_total: parseFloat(net_total),
            shop,
            paymentMethod
          },
          transaction,
        }
      );
  
      // Insert into Shop1_Invoice_Details
      for (const item of items) {
        const { product_name, unit_price, qty,stockid,product_category_id } = item;
        await sequelize.query(
          `
          INSERT INTO Shop1_Invoice_Details (
            inv_no,
            username,
            item_name,
            unitprice,
            qty,
            total
          ) VALUES (
            :inv_no,
            :username,
            :item_name,
            :unitprice,
            :qty,
            :total
          )
        `,
          {
            replacements: {
              inv_no,
              username,
              item_name : product_name,
              unitprice: parseFloat(unit_price),
              qty: parseInt(qty),
              total: parseFloat(qty*unit_price),
            },
            transaction,
          }
        );
      }
  
      // Commit transaction
      await transaction.commit();
      res.json({ message: 'Invoice created successfully' });
    } catch (error) {
      // Rollback transaction
      await transaction.rollback();
      return res.status(400).json({ error: error.message });
    }
  };
  
// Create invoice for Shop2
const CreateShop2Invoice = async (req, res) => {

    const {
      inv_no,
      username,
      inv_date,
      gross_total,
      discount,
      net_total,
      shop,
      paymentMethod,
      petid,
      items, // List of invoice detail items
    } = req.body;

    //console.log(req.body)
  
    const transaction = await sequelize.transaction();
    try {
      // Insert into Shop1_Invoice_Header
      await sequelize.query(
        `
        INSERT INTO Shop2_Invoice_Header (
          inv_no,
          username,
          inv_date,
          gross_total,
          discount,
          net_total,
          shop,
          paymentMethod,
          petid
        ) VALUES (
          :inv_no,
          :username,
          :inv_date,
          :gross_total,
          :discount,
          :net_total,
          :shop,
          :paymentMethod,
          :petid
        )
      `,
        {
          replacements: {
            inv_no,
            username,
            inv_date,
            gross_total: parseFloat(gross_total),
            discount: parseFloat(discount),
            net_total: parseFloat(net_total),
            shop,
            paymentMethod,
            petid
          },
          transaction,
        }
      );
  
      // Insert into Shop1_Invoice_Details
      for (const item of items) {
        const { product_name, unit_price, qty,stockid,product_category_id } = item;
        await sequelize.query(
          `
          INSERT INTO Shop2_Invoice_Details (
            inv_no,
            username,
            item_name,
            billed_name,
            unitprice,
            qty,
            total,
            stockid
          ) VALUES (
            :inv_no,
            :username,
            :item_name,
            :billed_name,
            :unitprice,
            :qty,
            :total,
            :stockid
          )
        `,
          {
            replacements: {
              inv_no,
              username,
              item_name : product_name,
              billed_name : (product_category_id === 1 || product_category_id === 2) ? 'Treatment Charges' : product_name,
              unitprice: parseFloat(unit_price),
              qty: parseInt(qty),
              total: parseFloat(qty*unit_price),
              stockid: parseInt(stockid),
            },
            transaction,
          }
        );
      }
  
      // Commit transaction
      await transaction.commit();
      res.json({ message: 'Invoice created successfully' });
    } catch (error) {
      // Rollback transaction
      await transaction.rollback();
      return res.status(400).json({ error: error.message });
    }
  };
  
// Create invoice for Shop3
const CreateShop3Invoice = async (req, res) => {

    const {
      inv_no,
      username,
      inv_date,
      gross_total,
      discount,
      net_total,
      shop,
      paymentMethod,
      petid,
      items, // List of invoice detail items
    } = req.body;

    //console.log(req.body)
  
    const transaction = await sequelize.transaction();
    try {
      // Insert into Shop1_Invoice_Header
      await sequelize.query(
        `
        INSERT INTO Shop3_Invoice_Header (
          inv_no,
          username,
          inv_date,
          gross_total,
          discount,
          net_total,
          shop,
          paymentMethod,
          petid
        ) VALUES (
          :inv_no,
          :username,
          :inv_date,
          :gross_total,
          :discount,
          :net_total,
          :shop,
          :paymentMethod,
          :petid
        )
      `,
        {
          replacements: {
            inv_no,
            username,
            inv_date,
            gross_total: parseFloat(gross_total),
            discount: parseFloat(discount),
            net_total: parseFloat(net_total),
            shop,
            paymentMethod,
            petid
          },
          transaction,
        }
      );
  
      // Insert into Shop1_Invoice_Details
      for (const item of items) {
        const { product_name, unit_price, qty,stockid,product_category_id } = item;
        await sequelize.query(
          `
          INSERT INTO Shop3_Invoice_Details (
            inv_no,
            username,
            item_name,
            billed_name,
            unitprice,
            qty,
            total,
            stockid
          ) VALUES (
            :inv_no,
            :username,
            :item_name,
            :billed_name,
            :unitprice,
            :qty,
            :total,
            :stockid
          )
        `,
          {
            replacements: {
              inv_no,
              username,
              item_name : product_name,
              billed_name : (product_category_id === 1 || product_category_id === 2) ? 'Treatment Charges' : product_name,
              unitprice: parseFloat(unit_price),
              qty: parseInt(qty),
              total: parseFloat(qty*unit_price),
              stockid: parseInt(stockid),
            },
            transaction,
          }
        );
      }
  
      // Commit transaction
      await transaction.commit();
      res.json({ message: 'Invoice created successfully' });
    } catch (error) {
      // Rollback transaction
      await transaction.rollback();
      return res.status(400).json({ error: error.message });
    }
  };
  



const getmaxshop1 = async (req,res) =>{
  
    try {
        const [results, metadata] = await sequelize.query(`
           SELECT COALESCE(max(invheader_key),0)+1 as inv_no
          FROM Shop1_Invoice_Header

        `);
        res.json(results);
    } catch (error) {
        return res.status(400).json({ error: error.message });
    }
}


const getbill = async (req,res) =>{
    
  try {
      const [results, metadata] = await sequelize.query(`
          SELECT invdetails_key,inv_no,username,item_name,unitprice,qty,total
              FROM Shop1_Invoice_Details
              where inv_no = :inv_no
      `, {
          replacements: {
              inv_no: req.body.inv_no,
          }
      });
      res.json(results);
       
    } catch (error) {
        return res.status(400).json({ error: error.message });
    }
}

const returnBill = async (req, res) => {
  const { invdetails_key, inv_no, total, qty, item_name, unitprice } = req.body;

  // console.log(invdetails_key);
  
  // Use the correct syntax to handle undefined returnQty
  var returnQty = (req.body.returnQty === undefined) ? qty : req.body.returnQty;



  const returnTotal = parseFloat(returnQty) * parseFloat(unitprice);

  // console.log(returnTotal);


  // Start a transaction
  const t = await sequelize.transaction();

  try {
    // 1. Update Shop1_Invoice_Details
    const [detailsResults] = await sequelize.query(
      `
      UPDATE Shop1_Invoice_Details 
      SET total = total - :returnTotal, qty = qty - :returnQty
      WHERE invdetails_key = :invdetails_key
      `,
      {
        replacements: { returnTotal,returnQty,invdetails_key },
        transaction: t,
      }
    );

    // 2. Update Shop1_Invoice_Header
    const [headerResults] = await sequelize.query(
      `
      UPDATE Shop1_Invoice_Header 
      SET 
        gross_total = gross_total - :returnTotal,
        net_total = net_total - :returnTotal
      WHERE inv_no = :inv_no
      `,
      {
        replacements: { returnTotal, inv_no },
        transaction: t,
      }
    );

    // 3. Update Shop2_Stock
    // This assumes you want to update the stock with the earliest expiry date for the given item
    const [stockResults] = await sequelize.query(
      `
      UPDATE Shop1_Stock s1
      SET s1.stock = s1.stock + :returnQty
      WHERE s1.itemName = :item_name
      `,
      {
        replacements: { returnQty, item_name },
        transaction: t,
      }
    );

    // Commit the transaction if all updates are successful
    await t.commit();

    // Optionally, send a combined response
    res.json({
      detailsUpdated: detailsResults,
      headerUpdated: headerResults,
      stockUpdated: stockResults,
      message: 'Return processed successfully.',
    });
  } catch (error) {
    // Rollback the transaction in case of any errors
    await t.rollback();
    console.error('Transaction failed:', error);
    res.status(400).json({ error: error.message });
  }

}

const returnBill2 = async (req,res) =>{

  const { invdetails_key, inv_no, total, qty, item_name,unitprice } = req.body;

  // console.log(invdetails_key);
  // Use the correct syntax to handle undefined returnQty
  var returnQty = (req.body.returnQty === undefined) ? qty : req.body.returnQty;

  const returnTotal = parseFloat(returnQty) * parseFloat(unitprice);

  // Start a transaction
  const t = await sequelize.transaction();

  try {
    // 1. Update Shop1_Invoice_Details
    const [detailsResults] = await sequelize.query(
      `
      UPDATE Shop2_Invoice_Details 
      SET total = total - :returnTotal, qty = qty - :returnQty
      WHERE invdetails_key = :invdetails_key
      `,
      {
        replacements: { returnTotal,returnQty,invdetails_key},
        transaction: t,
      }
    );

    // 2. Update Shop1_Invoice_Header
    const [headerResults] = await sequelize.query(
      `
      UPDATE Shop2_Invoice_Header 
      SET 
        gross_total = gross_total - :returnTotal,
        net_total = net_total - :returnTotal
      WHERE inv_no = :inv_no
      `,
      {
        replacements: { returnTotal, inv_no },
        transaction: t,
      }
    );

    // 3. Update Shop2_Stock
    // This assumes you want to update the stock with the earliest expiry date for the given item
    const [stockResults] = await sequelize.query(
      `
      UPDATE Shop2_Stock s1
      JOIN (
          SELECT MIN(stockExpireDate) AS minExpireDate
          FROM Shop2_Stock
          WHERE itemName = :item_name
      ) s2 ON s1.stockExpireDate = s2.minExpireDate
      SET s1.stock = s1.stock + :returnQty
      WHERE s1.itemName = :item_name
      `,
      {
        replacements: { returnQty, item_name },
        transaction: t,
      }
    );

    // Commit the transaction if all updates are successful
    await t.commit();

    // Optionally, send a combined response
    res.json({
      detailsUpdated: detailsResults,
      headerUpdated: headerResults,
      stockUpdated: stockResults,
      message: 'Return processed successfully.',
    });
  } catch (error) {
    // Rollback the transaction in case of any errors
    await t.rollback();
    console.error('Transaction failed:', error);
    res.status(400).json({ error: error.message });
  }
}

const returnBill3 = async (req,res) =>{

  const { invdetails_key, inv_no, total, qty, item_name,unitprice } = req.body;

  // console.log(invdetails_key);
  // Use the correct syntax to handle undefined returnQty
  var returnQty = (req.body.returnQty === undefined) ? qty : req.body.returnQty;

  //console.log(invdetails_key);

  // Start a transaction
  const t = await sequelize.transaction();
  
  try {
    // 1. Update Shop1_Invoice_Details
    const [detailsResults] = await sequelize.query(
      `
      UPDATE Shop3_Invoice_Details 
      SET total = total - :returnTotal, qty = qty - :returnQty
      WHERE invdetails_key = :invdetails_key
      `,
      {
        replacements: { returnTotal,returnQty,invdetails_key },
        transaction: t,
      }
    );

    // 2. Update Shop1_Invoice_Header
    const [headerResults] = await sequelize.query(
      `
      UPDATE Shop3_Invoice_Header 
      SET 
        gross_total = gross_total - :returnTotal,
        net_total = net_total - :returnTotal
      WHERE inv_no = :inv_no
      `,
      {
        replacements: { returnTotal, inv_no },
        transaction: t,
      }
    );

    // 3. Update Shop2_Stock
    // This assumes you want to update the stock with the earliest expiry date for the given item
    const [stockResults] = await sequelize.query(
      `
      UPDATE Shop3_Stock s1
      JOIN (
          SELECT MIN(stockExpireDate) AS minExpireDate
          FROM Shop3_Stock
          WHERE itemName = :item_name
      ) s2 ON s1.stockExpireDate = s2.minExpireDate
      SET s1.stock = s1.stock + :returnQty
      WHERE s1.itemName = :item_name
      `,
      {
        replacements: { returnQty, item_name },
        transaction: t,
      }
    );

    // Commit the transaction if all updates are successful
    await t.commit();

    // Optionally, send a combined response
    res.json({
      detailsUpdated: detailsResults,
      headerUpdated: headerResults,
      stockUpdated: stockResults,
      message: 'Return processed successfully.',
    });
  } catch (error) {
    // Rollback the transaction in case of any errors
    await t.rollback();
    console.error('Transaction failed:', error);
    res.status(400).json({ error: error.message });
  }
}



const getmaxshop2 = async (req,res) =>{
  
    try {
        const [results, metadata] = await sequelize.query(`
           SELECT COALESCE(max(invheader_key),0)+1 as inv_no
          FROM Shop2_Invoice_Header

        `);
        res.json(results);
    } catch (error) {
        return res.status(400).json({ error: error.message });
    }
}



const getmaxshop3 = async (req,res) =>{
  
    try {
        const [results, metadata] = await sequelize.query(`
           SELECT COALESCE(max(invheader_key),0)+1 as inv_no
          FROM Shop3_Invoice_Header

        `);
        res.json(results);
    } catch (error) {
        return res.status(400).json({ error: error.message });
    }
}


const getshop1Bills = async (req,res) =>{
  
    try {
        const [results, metadata] = await sequelize.query(`
           SELECT inv_no
          FROM Shop1_Invoice_Header

        `);
        res.json(results);
    } catch (error) {
        return res.status(400).json({ error: error.message });
    }
}
const getshop2Bills = async (req,res) =>{
  
    try {
        const [results, metadata] = await sequelize.query(`
              SELECT inv_no
          FROM Shop1_Invoice_Headerr

        `);
        res.json(results);
    } catch (error) {
        return res.status(400).json({ error: error.message });
    }
}
const getshop3Bills = async (req,res) =>{
  
    try {
        const [results, metadata] = await sequelize.query(`
                SELECT inv_no
          FROM Shop1_Invoice_Header

        `);
        res.json(results);
    } catch (error) {
        return res.status(400).json({ error: error.message });
    }
}




  
module.exports = {
    CreateShop1Invoice,
    CreateShop2Invoice,
    CreateShop3Invoice,
    getmaxshop1,
    getmaxshop2,
    getmaxshop3,
    getbill,
    returnBill,
    returnBill2,
    returnBill3,
    getshop1Bills,
    getshop2Bills,
    getshop3Bills
}