import axios from 'axios';

const API_URL = "https://your-api-url.com"; // Replace with your API

// Login function
const login = async (username, password) => {
  try {
    const response = await axios.post(`${API_URL}/login`, { username, password });
    const { token } = response.data;

    // Store token in localStorage or sessionStorage
    localStorage.setItem('token', token);

    return response.data;
  } catch (error) {
    throw error;
  }
};

// Logout function
const logout = () => {
  // Remove the token
  localStorage.removeItem('token');
};

// Get current token
const getToken = () => {
  return localStorage.getItem('token');
};

// Decode token to get user information
import jwt_decode from "jwt-decode";

const getUserInfo = () => {
  const token = getToken();
  if (token) {
    return jwt_decode(token);
  }
  return null;
};

export { login, logout, getToken, getUserInfo };
